<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Fnf_Info extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-fanfact-info-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'FanFact Info', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Fanfact Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		
		$this->add_control(
			'member_count', [
				'label' => esc_html__( 'Member Count', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'member_title', [
				'label' => esc_html__( 'Member Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'button_label', [
				'label' => esc_html__( 'Button Label', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'button_link', [
				'label' => esc_html__( 'Button Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'signature', [
				'label' => esc_html__( 'Signature Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'trafic_count', [
				'label' => esc_html__( 'Traffic Count', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'traffic_prefix', [
				'label' => esc_html__( 'Traffic Prefix', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'traffic_title', [
				'label' => esc_html__( 'Traffic Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'exp_count', [
				'label' => esc_html__( 'Exprience Count', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'exp_title', [
				'label' => esc_html__( 'Exprience Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="info-section">
		<div class="auto-container">
			<!-- Lower Box -->
			<div class="info-bar d-flex align-items-center">
				<ul class="member-list d-flex">
					<li class="title-anim"><?php echo esc_html($settings['member_count']);?> <span><?php echo esc_html($settings['member_title']);?></span></li>
                    <?php if(!empty($settings['button_label'])):?>
					    <li class="title-anim"><a href="<?php echo esc_url($settings['button_link']['url']);?>"><i class="fa fa-angle-right"></i> <span><?php echo esc_html($settings['button_label']);?></span></a></li>
                    <?php endif;?>
				</ul>
                <?php if(!empty($settings['signature']['url'])):?>
				    <div class="signature title-anim"><img src="<?php echo esc_url($settings['signature']['url']);?>" alt="" /></div>
                <?php endif;?>
			</div>
			<!-- Info Box -->
			<div class="info-box">
				<div class="box-inner d-flex justify-content-between align-items-center flex-wrap">
					
					<!-- Counter Column -->
                    <?php if(!empty($settings['trafic_count'])):?>
					<div class="counter-block">
						<div class="inner-box">
							<div class="counter"><span class="odometer" data-count="<?php echo esc_attr($settings['trafic_count']);?>"></span><?php if(!empty($settings['traffic_prefix'])){echo esc_attr($settings['traffic_prefix']);}?></div>
							<h6><?php echo esc_html($settings['traffic_title']);?></h6>
						</div>
					</div>
					<?php endif;?>
					<!-- Experiance Box -->
                    <?php if(!empty($settings['exp_count'])):?>
					<div class="experiance_box">
						<strong><?php echo esc_attr($settings['exp_count']);?></strong>
						<span><?php echo esc_html($settings['exp_title']);?></span>
					</div>
					<?php endif;?>
				</div>
			</div>
			
		</div>
	</div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Fnf_Info() );