<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Cta_Tw extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-cta-tw-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'CTA Two', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'CTA Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'call_icon', [
				'label' => esc_html__( 'Call Icon', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'phoone', [
				'label' => esc_html__( 'Phone Number', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="about-lower_box d-flex align-items-center">
        <!-- Button Box -->
        <?php if(!empty($settings['btn_label'])):?>
           <a class="btn-style-four theme-btn btn-item" href="<?php echo esc_url($settings['btn_link']['url']);?>">
                <div class="btn-wrap">
                    <span class="text-one"><?php echo esc_html($settings['btn_label']);?></span>
                    <span class="text-two"><?php echo esc_html($settings['btn_label']);?></span>
                </div>
                <i class="arrow fa-solid fa-arrow-down fa-fw"></i>
            </a>
        <?php endif;?>
        <!-- Phone Box -->
        <div class="about-phone_box">
            <div class="about-phone_inner">
                <?php if(!empty($settings['call_icon']['url'])):?>
                    <span class="about-phone_icon">
                        <img src="<?php echo esc_url($settings['call_icon']['url']);?>" alt="" />
                    </span>
                <?php endif;?>
                <?php echo esc_html($settings['title']);?>
                <?php if(!empty($settings['phoone'])):?>
                    <strong class="about_phone"><a href="tel:<?php echo $settings['phoone']?>"><?php echo esc_html($settings['phoone']);?></a></strong>
                <?php endif;?>
            </div>
        </div>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Cta_Tw() );