<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Contact_Infos extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-contact-infos-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Contact Info 2', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Fanfact Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_arrow', [
				'label' => esc_html__( 'Title Arrow', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'contact_title', [
				'label' => esc_html__( 'Contact Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'phone_no', [
				'label' => esc_html__( 'Phone Number', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'email', [
				'label' => esc_html__( 'Email', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'big_title', [
				'label' => esc_html__( 'Big Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'house_shape', [
				'label' => esc_html__( 'House Shape', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'arrow_two', [
				'label' => esc_html__( 'Arrow Two', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="contact-info-section">
		<div class="auto-container">
			
			<!-- Title Box -->
			<div class="title-box text-center">
                <?php if(!empty($settings['title_arrow']['url'])):?>
				    <span class="arrow"><img src="<?php echo esc_url($settings['title_arrow']['url']);?>" alt="" /></span>
                <?php endif;?>
				<h5><?php echo wp_kses( $settings['contact_title'], true );?></h5>
			</div>
			
			<div class="inner-container">
                <?php if(!empty($settings['house_shape']['url'])):?>
				    <div class="icon-layer" style="background-image:url(<?php echo esc_url($settings['house_shape']['url']);?>)"></div>
                <?php endif;?>
				<ul class="info">
                    <?php if(!empty($settings['phone_no'])):?>
					    <li><a href="tel:<?php echo esc_url($settings['phone_no']);?>"><?php echo wp_kses( $settings['phone_no'], true );?></a></li>
                    <?php endif;?>
                    <?php if(!empty($settings['email'])):?>
					    <li><a href="mailto:<?php echo esc_url($settings['email']);?>"><?php echo esc_html($settings['email']);?></a></li>
                    <?php endif;?>
				</ul>
				<!-- Sec Title -->
				<div class="sec-title centered">
                    <?php if(!empty($settings['big_title'])):?>
					    <div class="big-title title-anim"><?php echo wp_kses( $settings['big_title'], true )?></div>
                    <?php endif;?>
                    <?php if(!empty($settings['big_title'])):?>
					    <h2 class="title-anim"><?php echo wp_kses( $settings['title'], true )?></h2>
                    <?php endif;?>
                    <?php if(!empty($settings['arrow_two']['url'])):?>
					<div class="arrow title-anim"><img src="<?php echo esc_url($settings['arrow_two']['url']);?>" alt="" /></div>
                    <?php endif;?>
				</div>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Contact_Infos() );