<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class blog_v5 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'blog-v5';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blog V5', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_fnf_option',
			[
				'label' => esc_html__( 'Blog Info Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'subtitle', [
				'label' => esc_html__( 'SubTitle', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('LATEST NEWS' , 'constim-tools')
			]
		);
        $this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'default' => __('Our latest news' , 'constim-tools')
			]
		);
        $this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
				'default' => __('Contact our expert teams today for your free initial site
                                inspection and to discuss the Air.' , 'constim-tools')
			]
		);
        $this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
				'default' => __('VIEW MORE' , 'constim-tools')
			]
		);
        $this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $this->add_control(
			'postorder',
			[
				'label'     => esc_html__( 'Post Order', 'constim-tools' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'constim-tools' ),
					'DESC' => esc_html__( 'Descending', 'constim-tools' ),
				],
			]
		);
		
		$this->add_control(
			'pst_per_page',
			[
				'label'   => __( 'Posts Per Page', 'constim-tools' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 1,
			]
		);
		$this->add_control(
			'post_categories',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Categories', 'barnix-tools' ),
				'options'     => constim_blog_category(),
				'label_block' => true,
				'multiple'    => true,
			]
		);
        $this->add_control(
			'title_length',
			[
				'label'     => __( 'Title Length', 'constim-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
		$this->add_control(
			'excerpt_length',
			[
				'label'     => __( 'Excerpt Length', 'constim-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
		$this->add_control(
			'readmore_btn', [
				'label' => esc_html__( 'Read More Button', 'constim-tools' ),
				'default' => esc_html__( 'Read More', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_1',
			[
				'label' => __( 'Section Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'--Subtitle-Style--',
			[
				'label' => esc_html__( 'Subtitle Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Subtitle-Color',
			[
				'label' => esc_html__( 'Subtitle Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Subtitle-Typography',
				'label' => esc_html__( 'Subtitle Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_title',
			]
		);

		$this->add_control(
			'--Title-Style--',
			[
				'label' => esc_html__( 'Title Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Title-Color',
			[
				'label' => esc_html__( 'Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_heading' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Title-Typography',
				'label' => esc_html__( 'Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_heading',
			]
		);

		$this->add_control(
			'--Description-Style--',
			[
				'label' => esc_html__( 'Description Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Description-Color',
			[
				'label' => esc_html__( 'Description Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Description-Typography',
				'label' => esc_html__( 'Description Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_text',
			]
		);
		$this->add_control(
			'--Button-Style--',
			[
				'label' => esc_html__( 'Button Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->start_controls_tabs('tpcnt-Button');
		$this->start_controls_tab(
			'tab_controls_normal-Button',
			[
				'label' => esc_html__( 'Normal', 'appilo' ),
			]
		);

		$this->add_control(
			'Button-Color',
			[
				'label' => esc_html__( 'Button Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five .btn-wrap .text-one' => 'color: {{VALUE}}',
					'{{WRAPPER}} .btn-style-five' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Button-Typography',
				'label' => esc_html__( 'Button Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .btn-style-five',
			]
		);
		$this->add_control(
			'Button-BG-Color',
			[
				'label' => esc_html__( 'Button BG Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_controls_hover-Button',
			[
				'label' => esc_html__( 'Hover', 'appilo' ),
			]
		);

		$this->add_control(
			'Button-Hover-Color',
			[
				'label' => esc_html__( 'Button Hover Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five:hover .btn-wrap .text-two' => 'color: {{VALUE}}',
					'{{WRAPPER}} .btn-style-five:hover .arrow' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Button-Hover-BG-Color',
			[
				'label' => esc_html__( 'Button Hover BG Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five:hover:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'Blog_style_1',
			[
				'label' => __( 'Blog Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('tpcnt');
		$this->start_controls_tab(
			'tab_controls_normal',
			[
				'label' => esc_html__( 'Normal', 'appilo' ),
			]
		);
		$this->add_control(
			'date-Color',
			[
				'label' => esc_html__( 'Date Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block_three_post' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Date-Typography',
				'label' => esc_html__( 'Date Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .news-block_three_post',
			]
		);
		$this->add_control(
			'Date-BG-Color',
			[
				'label' => esc_html__( 'Date BG Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block_three_post' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'Blog-Title-Color',
			[
				'label' => esc_html__( 'Blog Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block_three_title a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Blog-Title-Typography',
				'label' => esc_html__( 'Blog Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .news-block_three_title a',
			]
		);

		$this->add_control(
			'Blog-Excerpt-Color',
			[
				'label' => esc_html__( 'Blog Excerpt Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block_three-text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Blog-Excerpt-Typography',
				'label' => esc_html__( 'Blog Excerpt Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .news-block_three-text',
			]
		);
		$this->add_control(
			'Blog-Read-More-Color',
			[
				'label' => esc_html__( 'Blog Read More Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block_three-more' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Blog-Read-More-Typography',
				'label' => esc_html__( 'Blog Read More Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .news-block_three-more',
			]
		);
		$this->add_control(
			'Blog-Nav-Color',
			[
				'label' => esc_html__( 'Blog Nav Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-three .owl-nav .owl-prev' => 'color: {{VALUE}}',
					'{{WRAPPER}} .news-three .owl-nav .owl-next' => 'color: {{VALUE}}',
					'{{WRAPPER}} .news-three .owl-dots .owl-dot span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .news-three .owl-dots .owl-dot.active span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Blog-Border-Color',
			[
				'label' => esc_html__( 'Blog Border Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-three .owl-dots .owl-dot span:after' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_controls_hover',
			[
				'label' => esc_html__( 'Hover', 'appilo' ),
			]
		);

		$this->add_control(
			'Blog-Title-Hover-Color',
			[
				'label' => esc_html__( 'Blog Title Hover Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block_three_title a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'Blog-Read-More-Hover-Color',
			[
				'label' => esc_html__( 'Blog Read More Hover Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-block_three-more:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'Blog-Nav-Hover-Color',
			[
				'label' => esc_html__( 'Blog Nav Hover Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .news-three .owl-nav .owl-prev:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .news-three .owl-nav .owl-next:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();		

    ?>
        <!-- News Three -->
        <div class="news-three style-two">
            <div class="auto-container">
                <!-- Sec Title Two -->
                <div class="sec-title-two">
                    <div class="d-flex justify-content-between align-items-center flex-wrap">
                        <div class="left-box">
	                        <?php if(!empty($settings['subtitle'])):?>
                                <div class="sec-title-two_title"><?php echo wp_kses( $settings['subtitle'], true )?></div>
	                        <?php endif;?>
                            <h2 class="sec-title-two_heading"><?php echo wp_kses( $settings['title'], true )?></h2>
                        </div>
                        <div class="right-box d-flex align-items-center flex-wrap">
                            <div class="sec-title-two_text"><?php echo wp_kses( $settings['description'], true )?></div>
		                    <?php if(!empty($settings['btn_label'])):?>
                                <div class="news-three_button-box">
                                    <!-- Button Box -->
                                    <a class="btn-style-five theme-btn btn-item" href="<?php echo esc_url($settings['btn_link']['url']);?>">
                                        <div class="btn-wrap">
                                            <span class="text-one"><?php echo esc_html($settings['btn_label']);?></span>
                                            <span class="text-two"><?php echo esc_html($settings['btn_label']);?></span>
                                        </div>
                                        <i class="arrow fa-solid fa-arrow-right fa-fw"></i>
                                    </a>
                                </div>
		                    <?php endif;?>
                        </div>
                    </div>
                </div>
                <div class="news-carousel-two owl-carousel owl-theme">
                <?php
                $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
                $args = array(
                    'post_type'           => 'post',
                    'posts_per_page'      => !empty( $settings['pst_per_page'] ) ? $settings['pst_per_page'] : 1,
                    'post_status'         => 'publish',
                    'ignore_sticky_posts' => 1,
                    'order'               => $settings['postorder'],
                    'paged' => $paged
                );
                if( ! empty($settings['post_categories'] ) ){
                    $args['category_name'] = implode(',', $settings['post_categories']);
                }
                $query = new \WP_Query( $args );

                if ( $query->have_posts() ) {

                    while ( $query->have_posts() ) {
				$query->the_post();
				$constim_size = 'constim-image-size-4';
				$excerpt = wp_trim_words( get_the_excerpt(), $settings['excerpt_length'], '' );
				$title = wp_trim_words( get_the_title(), $settings['title_length'], '' );
				?>
                    <!-- News Three / Style Two -->
                    <div class="news-block_three style-two">
                        <div class="news-block_three-inner">
                            <div class="news-block_three-image">
	                            <?php the_post_thumbnail( $constim_size );?>
                                <div class="news-block_three_post"><span class="news-block_three-calander fa fa-calendar"></span><?php echo date(get_option('date_format')); ?></div>
                            </div>
                            <div class="news-block_three-lower-content">
                                <h5 class="news-block_three_title"><a href="<?php the_permalink();?>"><?php echo esc_html($title);?></a></h5>
                                <div class="news-block_three-text"><?php echo $excerpt?></div>
                                <a class="news-block_three-more" href="<?php the_permalink();?>"><?php echo esc_html($settings['readmore_btn']);?></a>
                            </div>
                        </div>
                    </div>
                <?php
                    }

	                wp_reset_query();
                }

                ?>

                </div>
            </div>
        </div>
        <!-- End News Three -->
    
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new blog_v5() );