<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Blog_Grid_Item extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'constim-blog-grid-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Constim Blog Grid', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_fnf_option',
			[
				'label' => esc_html__( 'Blog Info Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'postorder',
			[
				'label'     => esc_html__( 'Post Order', 'constim-tools' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'constim-tools' ),
					'DESC' => esc_html__( 'Descending', 'constim-tools' ),
				],
			]
		);
		
		$this->add_control(
			'pst_per_page',
			[
				'label'   => __( 'Posts Per Page', 'constim-tools' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 1,
			]
		);
		$this->add_control(
			'post_categories',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Categories', 'barnix-tools' ),
				'options'     => constim_blog_category(),
				'label_block' => true,
				'multiple'    => true,
			]
		);
        
		$this->add_control(
			'title_length',
			[
				'label'     => __( 'Title Length', 'constim-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
		$this->add_control(
			'readmore_btn', [
				'label' => esc_html__( 'Read More Button', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'constim-tools'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
            'thm_clr',
            [
                'label' => esc_html__('Theme color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .news-block .post-info .post-inner .post-image:before' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .news-block .post-info .post-inner span,{{WRAPPER}} .news-block .post-meta li .icon,{{WRAPPER}} .news-block h5 a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'tm_bg',
            [
                'label' => esc_html__('Meta', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'm_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .news-block .post-meta li',
            ]
        );

        $this->add_control(
            'm_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .news-block .post-meta li' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'tt_bg',
            [
                'label' => esc_html__('Title', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 't_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .news-block h5',
            ]
        );

        $this->add_control(
            't_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .news-block h5 a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();		

    ?>
    <section class="news-section">
    <div class="auto-container">
        <div class="inner-container">
            <div class="news-carousel owl-carousel owl-theme">
                <?php		
                    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;			
                    $args = array(
                        'post_type'           => 'post',
                        'posts_per_page'      => !empty( $settings['pst_per_page'] ) ? $settings['pst_per_page'] : 1,
                        'post_status'         => 'publish',
                        'ignore_sticky_posts' => 1,
                        'order'               => $settings['postorder'],
                        'paged' => $paged
                    );
                    if( ! empty($settings['post_categories'] ) ){
                        $args['category_name'] = implode(',', $settings['post_categories']);
                    }
                    $query = new \WP_Query( $args );
                    ?>
                    <?php
                    if ( $query->have_posts() ) {
                    while ( $query->have_posts() ) {
                    $query->the_post();
                    $constim_size = 'constim-image-size-1';
                    $title = wp_trim_words( get_the_title(), $settings['title_length'], '' );
                ?>
                <!-- News Block -->
                <div class="news-block">
                    <div class="inner-box">
                        <!-- Post Info -->
                        <div class="post-info">
                            <div class="post-inner">
                                <div class="post-image">
                                    <?php constim_post_author_avatars(24);?>
                                </div>
                                <?php esc_html_e('By:', 'constim-tools');?> <span><?php the_author();?></span>
                            </div>
                        </div>
                        <div class="image">
                            <?php the_post_thumbnail( $constim_size );?>
                            <?php the_post_thumbnail( $constim_size );?>
                        </div>
                        <div class="lower-content">
                            <ul class="post-meta">
                                <li><span class="icon fal fa-calendar-check fa-fw"></span><?php echo date(get_option('date_format')); ?></li>
                                <li><span class="icon fa-solid fa-comments fa-fw"></span><?php esc_html_e( 'Comments', 'constim-tools' )?> (<?php echo esc_attr(get_comments_number());?>)</li>
                            </ul>
                            <h5><a href="<?php the_permalink();?>"><?php echo esc_html($title);?></a></h5>
                            <?php if(!empty($settings['readmore_btn'])): ?>
                                <a class="read-more" href="<?php the_permalink();?>"><?php echo esc_html($settings['readmore_btn']);?></a>
                            <?php endif;?>
                        </div>
                    </div>
                </div>
                <?php } ?>
                <?php wp_reset_query(); } ?>
                
            </div>
        </div>
    </div>
</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Blog_Grid_Item() );