<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Blog_Grid_Item_V2 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'constim-blog-grid-v2-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Constim Blog Grid V2', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_fnf_option',
			[
				'label' => esc_html__( 'Blog Info Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'postorder',
			[
				'label'     => esc_html__( 'Post Order', 'constim-tools' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'constim-tools' ),
					'DESC' => esc_html__( 'Descending', 'constim-tools' ),
				],
			]
		);
		
		$this->add_control(
			'pst_per_page',
			[
				'label'   => __( 'Posts Per Page', 'constim-tools' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 1,
			]
		);
		$this->add_control(
			'post_categories',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Categories', 'barnix-tools' ),
				'options'     => constim_blog_category(),
				'label_block' => true,
				'multiple'    => true,
			]
		);
        
		$this->add_control(
			'title_length',
			[
				'label'     => __( 'Title Length', 'constim-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
		$this->add_control(
			'readmore_btn', [
				'label' => esc_html__( 'Read More Button', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();		

    ?>
    <div class="row clearfix">
				
        <?php		
            $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;			
            $args = array(
                'post_type'           => 'post',
                'posts_per_page'      => !empty( $settings['pst_per_page'] ) ? $settings['pst_per_page'] : 1,
                'post_status'         => 'publish',
                'ignore_sticky_posts' => 1,
                'order'               => $settings['postorder'],
                'paged' => $paged
            );
            if( ! empty($settings['post_categories'] ) ){
                $args['category_name'] = implode(',', $settings['post_categories']);
            }
            $query = new \WP_Query( $args );
            ?>
            <?php
            if ( $query->have_posts() ) {
            while ( $query->have_posts() ) {
            $query->the_post();
            $constim_size = 'constim-image-size-2';
            $title = wp_trim_words( get_the_title(), $settings['title_length'], '' );
        ?>
        <!-- News Block Two -->
        <div class="news-block-two col-lg-4 col-md-6 col-sm-12">
            <div class="inner-box">
                <div class="image">
                    <?php the_post_thumbnail( $constim_size );?>
                    <?php the_post_thumbnail( $constim_size );?>
                    <!-- Post Info -->
                    <div class="post-info">
                        <div class="post-inner">
                            <div class="post-image">
                                <?php constim_post_author_avatars(24);?>
                            </div>
                            <?php esc_html_e('By:', 'constim-tools');?> <span><?php the_author();?></span>
                        </div>
                    </div>
                </div>
                <div class="lower-content">
                    <ul class="post-meta">
						<li><span class="icon fal fa-calendar-check fa-fw"></span><?php echo date(get_option('date_format')); ?></li>
                    	<li><span class="icon fa-solid fa-comments fa-fw"></span><?php esc_html_e( 'Comments', 'constim-tools' )?> (<?php echo esc_attr(get_comments_number());?>)</li>
                    </ul>
                    <h5><a href="<?php the_permalink();?>"><?php echo esc_html($title);?></a></h5>
                    <?php if(!empty($settings['readmore_btn'])): ?>
                        <a class="read-more" href="<?php the_permalink();?>"><?php echo esc_html($settings['readmore_btn']);?></a>
                    <?php endif;?>
                </div>
            </div>
        </div>
        <?php } ?>
        <?php wp_reset_query(); } ?>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Blog_Grid_Item_V2() );