<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Blog_Grid_Item_3 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'constim-blog-grid-3-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Constim Blog Grid 3', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_fnf_option',
			[
				'label' => esc_html__( 'Blog Info Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'subtitle', [
				'label' => esc_html__( 'SubTitle', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $this->add_control(
			'postorder',
			[
				'label'     => esc_html__( 'Post Order', 'constim-tools' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'constim-tools' ),
					'DESC' => esc_html__( 'Descending', 'constim-tools' ),
				],
			]
		);
		
		$this->add_control(
			'pst_per_page',
			[
				'label'   => __( 'Posts Per Page', 'constim-tools' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 1,
			]
		);
		$this->add_control(
			'post_categories',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Categories', 'barnix-tools' ),
				'options'     => constim_blog_category(),
				'label_block' => true,
				'multiple'    => true,
			]
		);
        $this->add_control(
			'title_length',
			[
				'label'     => __( 'Title Length', 'constim-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
		$this->add_control(
			'excerpt_length',
			[
				'label'     => __( 'Excerpt Length', 'constim-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
		$this->add_control(
			'readmore_btn', [
				'label' => esc_html__( 'Read More Button', 'constim-tools' ),
				'default' => esc_html__( 'Read More', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();		

    ?>
    <section class="news-three">
		<div class="auto-container">
			<!-- Sec Title Two -->
			<div class="sec-title-two">
				<div class="d-flex justify-content-between align-items-center">
					<div class="left-box">
                        <?php if(!empty($settings['subtitle'])):?>
						    <div class="sec-title-two_title"><?php echo wp_kses( $settings['subtitle'], true )?></div>
                        <?php endif;?>
						<h2 class="sec-title-two_heading"><?php echo wp_kses( $settings['title'], true )?></h2>
					</div>
					<div class="right-box d-flex align-items-center">
						<div class="sec-title-two_text"><?php echo wp_kses( $settings['description'], true )?></div>
                        <?php if(!empty($settings['btn_label'])):?>
                            <div class="news-three_button-box">
                                <!-- Button Box -->
                                <a class="btn-style-four theme-btn btn-item" href="<?php echo esc_url($settings['btn_link']['url']);?>">
                                    <div class="btn-wrap">
                                        <span class="text-one"><?php echo esc_html($settings['btn_label']);?></span>
                                        <span class="text-two"><?php echo esc_html($settings['btn_label']);?></span>
                                    </div>
                                    <i class="arrow fa-solid fa-arrow-down fa-fw"></i>
                                </a>
                            </div>
                        <?php endif;?>
					</div>
				</div>
			</div>
			<div class="news-carousel-two owl-carousel owl-theme">
                <?php		
                    $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;			
                    $args = array(
                        'post_type'           => 'post',
                        'posts_per_page'      => !empty( $settings['pst_per_page'] ) ? $settings['pst_per_page'] : 1,
                        'post_status'         => 'publish',
                        'ignore_sticky_posts' => 1,
                        'order'               => $settings['postorder'],
                        'paged' => $paged
                    );
                    if( ! empty($settings['post_categories'] ) ){
                        $args['category_name'] = implode(',', $settings['post_categories']);
                    }
                    $query = new \WP_Query( $args );
                    ?>
                    <?php
                    if ( $query->have_posts() ) {
                    while ( $query->have_posts() ) {
                    $query->the_post();
                    $constim_size = 'constim-image-size-4';
                    $excerpt = wp_trim_words( get_the_excerpt(), $settings['excerpt_length'], '' );
                    $title = wp_trim_words( get_the_title(), $settings['title_length'], '' );
                ?>
                    <!-- News Three -->
                    <div class="news-block_three">
                        <div class="news-block_three-inner">
                            <div class="news-block_three-image">
                                <?php the_post_thumbnail( $constim_size );?>
                                <div class="news-block_three_post"><span class="news-block_three-calander fa fa-calendar"></span><?php echo date(get_option('date_format')); ?></div>
                            </div>
                            <div class="news-block_three-lower-content">
                                <h5 class="news-block_three_title"><a href="<?php the_permalink();?>"><?php echo esc_html($title);?></a></h5>
                                <div class="news-block_three-text"><?php echo $excerpt?></div>
                                <a class="news-block_three-more" href="<?php the_permalink();?>"><?php echo esc_html($settings['readmore_btn']);?></a>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                    <?php wp_reset_query(); } ?>
                </div>
		</div>
	</section>
    
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Blog_Grid_Item_3() );