<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_App_Download extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-apps-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'App Download', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'App Download Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'shadow_shape', [
				'label' => esc_html__( 'Shape', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'map_img', [
				'label' => esc_html__( 'Map Image', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'app_1', [
				'label' => esc_html__( 'App One Logo', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'app_1_link', [
				'label' => esc_html__( 'App One Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->add_control(
			'app_2', [
				'label' => esc_html__( 'App Two Logo', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'app_2_link', [
				'label' => esc_html__( 'App Two Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

		$this->add_control(
			'mobile_screen', [
				'label' => esc_html__( 'Mobile Screen', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
 
		$this->end_controls_section();

		$this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'constim-tools'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
            'thm_clr',
            [
                'label' => esc_html__('Theme color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .app-section .content h3 span' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            't_bg',
            [
                'label' => esc_html__('Title', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 't_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .app-section .content h3',
            ]
        );

        $this->add_control(
            't_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .app-section .content h3' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="app-section">
		<div class="auto-container">
			<div class="inner-container">
                <?php if($settings['shadow_shape']['url']):?>
				    <div class="shadow-layer" style="background-image: url(<?php echo esc_url($settings['shadow_shape']['url']);?>)"></div>
                <?php endif;?>
				<div class="d-flex align-items-center flex-wrap">
                    <?php if($settings['map_img']['url']):?>
                        <div class="image">
                            <img src="<?php echo esc_url($settings['map_img']['url']);?>" alt="" />
                        </div>
                    <?php endif;?>
					<div class="content">
						<h3><?php echo wp_kses( $settings['title'], true );?></h3>
						<!-- App Buttons -->
						<div class="app-buttons">
                            <?php if($settings['app_1']['url']):?>
							    <a class="app" href="<?php echo esc_url($settings['app_1_link']['url']);?>"><img src="<?php echo esc_url($settings['app_1']['url']);?>" alt="" /></a>
                            <?php endif;?>
                            <?php if($settings['app_2']['url']):?>
							    <a class="app" href="<?php echo esc_url($settings['app_2_link']['url']);?>"><img src="<?php echo esc_url($settings['app_2']['url']);?>" alt="" /></a>
                            <?php endif;?>
						</div>
					</div>
				</div>
                <?php if($settings['mobile_screen']['url']):?>
                    <div class="mobile award__text">
                        <img src="<?php echo esc_url($settings['mobile_screen']['url']);?>" alt="" />
                    </div>
                <?php endif;?>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_App_Download() );