<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_Accordions extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-accordions-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Accordion', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Accordions Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'is_active',
			[
				'label' => esc_html__( 'Active Tab', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'constim-tools' ),
				'label_off' => esc_html__( 'NO', 'constim-tools' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'accordion_contetn', [
				'label' => esc_html__( 'Accordion Content', 'constim-tools' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'accordions',
			[
				'label' => esc_html__( 'Add Accordion Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="inner-container">
				
        <!-- Accordion Box -->
        <ul class="accordion-box">
            
            <!-- Block -->
            <?php foreach($settings['accordions'] as $item):?>
            <li class="accordion block">
                <div class="acc-btn <?php if($item['is_active'] == 'yes'){echo esc_attr('active');}?>"><div class="icon-outer"><span class="icon icon-plus fa fa-plus"></span> <span class="icon icon-minus fa fa-minus"></span></div><?php echo wp_kses( $item['title'], true )?></div>
                <div class="acc-content <?php if($item['is_active'] == 'yes'){echo esc_attr('current');}?>">
                    <div class="content">
                        <div class="text"><?php echo wp_kses( $item['accordion_contetn'], true )?></div>
                    </div>
                </div>
            </li>
            <?php endforeach;?>
        </ul>
        
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_Accordions() );