<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_About_Tabs extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-about-tabs-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Tabs', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'About Option', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape', 'constim-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'is_active',
			[
				'label' => esc_html__( 'Active Tab', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'constim-tools' ),
				'label_off' => esc_html__( 'NO', 'constim-tools' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Project Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'content', [
				'label' => esc_html__( 'About Short Content', 'constim-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		
		$repeater->add_control(
			'project_count', [
				'label' => esc_html__( 'Project Count', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'project_title', [
				'label' => esc_html__( 'Project Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'button_label', [
				'label' => esc_html__( 'Button Label', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'button_link', [
				'label' => esc_html__( 'Button Link', 'constim-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'client_count', [
				'label' => esc_html__( 'Client Count', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'client_title', [
				'label' => esc_html__( 'Client Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'exprience_count', [
				'label' => esc_html__( 'Exprience Count', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'exprience_title', [
				'label' => esc_html__( 'Exprience Title', 'constim-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        

		$this->add_control(
			'abouts_tabs',
			[
				'label' => esc_html__( 'Add About Item', 'constim-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <section class="mission-section">
        <?php if(!empty($settings['shape']['url'])):?>
		    <div class="pattern-layer" style="background-image:url(<?php echo esc_url($settings['shape']['url']);?>)"></div>
        <?php endif;?>
		<div class="auto-container">
			<div class="inner-container">
				<!-- Mission Info Tabs -->
				<div class="mission-info-tabs">
					<!-- Mission Tabs -->
					<div class="mission-tabs tabs-box clearfix">
						
						<!-- Tab Btns -->
						<ul class="tab-btns tab-buttons clearfix">
                            <?php foreach($settings['abouts_tabs'] as $item):?>
							    <li data-tab="#prod-mission<?php echo esc_attr($item['_id']);?>" class="tab-btn <?php if($item['is_active'] == 'yes'){ echo esc_attr('active-btn');}?>"><?php echo esc_html($item['title']);?></li>
                            <?php endforeach;?>
						</ul>
				
						<!-- Tabs Container -->
						<div class="tabs-content">
							
							
							<!-- Tab / Active Tab -->
                            <?php foreach($settings['abouts_tabs'] as $item):?>
							<div class="tab <?php if($item['is_active'] == 'yes'){ echo esc_attr('active-tab');}?>" id="prod-mission<?php echo esc_attr($item['_id']);?>">
								<div class="text"><?php echo wp_kses( $item['content'], true )?></div>
								<div class="row clearfix">
									<div class="col-lg-9 col-md-12 col-sm-12">
										<!-- Counter -->
										<div class="counter"><span class="odometer" data-count="<?php echo esc_attr($item['project_count']);?>"></span>+</div>
										<div class="mission-project"><a href="<?php echo esc_url($item['button_link']['url']);?>"><?php echo esc_html($item['project_title']);?></a></div>
										<!-- Button Box -->
                                        <?php if(!empty($item['button_label'])):?>
										<div id="button-box">
											<a class="btn-style-one theme-btn btn-item" href="<?php echo esc_url($item['button_link']['url']);?>">
												<div class="btn-wrap">
													<span class="text-one"><?php echo esc_html($item['button_label']);?></span>
													<span class="text-two"><?php echo esc_html($item['button_label']);?></span>
												</div>
												<i class="arrow fa-solid fa-arrow-down fa-fw"></i>
											</a>
										</div>
                                        <?php endif;?>
									</div>
									<div class="col-lg-3 col-md-12 col-sm-12">
										
										<!-- Counter Column -->
                                        <?php if(!empty($item['client_count'])):?>
										<div class="experience-counter_block">
											<div class="inner-box title-anim">
												<div class="experience-counter">+0<span class="odometer" data-count="<?php echo esc_attr($item['client_count']);?>"></span></div>
												<h6 class="experience-counter_text"><?php echo esc_html($item['client_title']);?></h6>
											</div>
										</div>
										<?php endif;?>
										<!-- Counter Column -->
                                        <?php if(!empty($item['exprience_count'])):?>
										<div class="experience-counter_block">
											<div class="inner-box title-anim">
												<div class="experience-counter">+0<span class="odometer" data-count="<?php echo esc_attr($item['exprience_count']);?>"></span></div>
												<h6 class="experience-counter_text"><?php echo esc_html($item['exprience_title']);?></h6>
											</div>
										</div>
										<?php endif;?>
									</div>
								</div>
							</div>
							<?php endforeach;?>
							
						</div>
							
					</div>
				</div>
				
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_About_Tabs() );