<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
if ( !defined( 'ABSPATH' ) ) {
    exit;
} // Exit if accessed directly.

class Constim_About_Info extends Widget_Base
{
    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'hos-about-info-id';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__( 'About Info', 'constim-tools' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'appi-custom-icon';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['constim_widgets'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
			'constim_sec_h_option',
			[
			    'label' => esc_html__( 'About Option', 'constim-tools' ),
			    'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'bg_shape', [
			    'label' => esc_html__( 'Background Shape', 'constim-tools' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,
			]
		);

        $this->add_control(
			'about_img', [
			    'label' => esc_html__( 'About Image', 'constim-tools' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,
			]
		);

        $this->add_control(
			'title', [
			    'label' => esc_html__( 'Title', 'constim-tools' ),
			    'type' => Controls_Manager::TEXT,
			    'label_block' => true,
			]
		);

        $this->add_control(
			'description', [
			    'label' => esc_html__( 'Description', 'constim-tools' ),
			    'type' => Controls_Manager::TEXTAREA,
			    'label_block' => true,
			]
		);

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'count', [
			    'label' => esc_html__( 'Count', 'constim-tools' ),
			    'type' => Controls_Manager::TEXT,
			    'label_block' => true,
			]
		);
        $repeater->add_control(
			'prefix', [
			    'label' => esc_html__( 'Prefix', 'constim-tools' ),
			    'type' => Controls_Manager::TEXT,
			    'label_block' => true,
			]
		);

        $repeater->add_control(
			'title', [
			    'label' => esc_html__( 'Title', 'constim-tools' ),
			    'type' => Controls_Manager::TEXT,
			    'label_block' => true,
			]
		);

        $this->add_control(
			'counters',
			[
			    'label' => esc_html__( 'Counter', 'constim-tools' ),
			    'type' => \Elementor\Controls_Manager::REPEATER,
			    'fields' => $repeater->get_controls(),
			    'title_field' => '{{{ title }}}',
			]
		);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
			    'name' => 'background',
			    'label' => esc_html__('List Item image', 'constim-tools'),
			    'types' => ['classic'],
			    'excude' => ['color'],
			    'selector' => '{{WRAPPER}} .management-section .options li:before',
			]
		);
        $this->add_control(
			'list_desc', [
			    'label' => esc_html__( 'List Description', 'constim-tools' ),
			    'type' => Controls_Manager::WYSIWYG,
			    'label_block' => true,
			]
		);

        $this->add_control(
			'member_count', [
			    'label' => esc_html__( 'Member Count', 'constim-tools' ),
			    'type' => Controls_Manager::TEXT,
			    'label_block' => true,
			]
		);
        $this->add_control(
			'member_title', [
			    'label' => esc_html__( 'Member Title', 'constim-tools' ),
			    'type' => Controls_Manager::TEXT,
			    'label_block' => true,
			]
		);
        $this->add_control(
			'button_label', [
			    'label' => esc_html__( 'Button Label', 'constim-tools' ),
			    'type' => Controls_Manager::TEXT,
			    'label_block' => true,
			]
		);
        $this->add_control(
			'button_link', [
			    'label' => esc_html__( 'Button Link', 'constim-tools' ),
			    'type' => Controls_Manager::URL,
			    'label_block' => true,
			]
		);

        $this->add_control(
			'signature', [
			    'label' => esc_html__( 'Signature Image', 'constim-tools' ),
			    'type' => Controls_Manager::MEDIA,
			    'label_block' => true,
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'constim-tools'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
            't_hd',
            [
                'label' => esc_html__('Title', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 't_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .management-section .content-column h2',
            ]
        );

        $this->add_control(
            't_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .management-section .content-column h2' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'd_hd',
            [
                'label' => esc_html__('Description', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'd_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .management-section .content-column .text',
            ]
        );

        $this->add_control(
            'd_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .management-section .content-column .text' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'c_t',
            [
                'label' => esc_html__('Counter', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'ct_typo',
                'label' => esc_html__('Title Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .management-section .counter-block .counter',
            ]
        );

        $this->add_control(
            'ct_clr',
            [
                'label' => esc_html__('Title Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .management-section .counter-block .counter' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'cd_typo',
                'label' => esc_html__('Description Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .management-section .counter-block h6',
            ]
        );

        $this->add_control(
            'cd_clr',
            [
                'label' => esc_html__('Description Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .management-section .counter-block h6' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'l_hd',
            [
                'label' => esc_html__('List', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'l_typo',
                'label' => esc_html__('Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .management-section .options li',
            ]
        );

        $this->add_control(
            'l_clr',
            [
                'label' => esc_html__('Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .management-section .options li' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_control(
            'c_hd',
            [
                'label' => esc_html__('Circle', 'thepack'),
                'type' => Controls_Manager::HEADING,
				'separator' => 'after',
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'cx_typo',
                'label' => esc_html__('Title Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .management-section .member-list li',
            ]
        );

        $this->add_control(
            'cx_clr',
            [
                'label' => esc_html__('Title Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .management-section .member-list li' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'cxd_typo',
                'label' => esc_html__('Description Typography', 'thepack'),
                'selector' => '{{WRAPPER}} .management-section .member-list li span',
            ]
        );

        $this->add_control(
            'cxd_clr',
            [
                'label' => esc_html__('Description Color', 'thepack'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .management-section .member-list li span' => 'color: {{VALUE}};',
                ],
            ]
        );
		
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display(); ?>
    <section class="management-section" style="background-image: url(<?php echo esc_url($settings['bg_shape']['url']); ?>)">
		<div class="auto-container">
			<div class="row clearfix align-items-center">
				<!-- Image Column -->
				<div class="image-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<div class="image wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
							<img src="<?php echo esc_url($settings['about_img']['url']); ?>" alt="" />
						</div>
					</div>
				</div>
				<!-- Content Column -->
				<div class="content-column col-lg-6 col-md-12 col-sm-12">
					<div class="inner-column">
						<?php if (!empty($settings['title'])):?>
							<h2><?php echo wp_kses( $settings['title'], true ); ?></h2>
						<?php endif; ?>
						<div class="text"><?php echo wp_kses( $settings['description'], true ); ?></div>
						<div class="row clearfix">

							<!-- Counter Column -->
							<?php foreach ($settings['counters'] as $item):?>
							<div class="counter-block col-lg-5 col-md-6 col-sm-12">
								<div class="inner-box title-anim">
									<div class="counter"><?php if (!empty($item['prefix'])) {
            echo esc_html($item['prefix']);
        } ?><span class="odometer" data-count="<?php echo esc_attr($item['count']); ?>"></span></div>
									<h6><?php echo esc_html($item['title']); ?></h6>
								</div>
							</div>
							<?php endforeach; ?>
						</div>
						<?php if (!empty($settings['list_desc'])):?>
						<div class="options">
							<?php echo wp_kses( $settings['list_desc'], true ); ?>
						</div>
						<?php endif; ?>
						<!-- Lower Box -->
						<div class="lower-box d-flex align-items-center">
							<ul class="member-list d-flex">
								
								<?php if (!empty($settings['member_title'])):?>
									<li class="title-anim"><?php echo esc_html($settings['member_count']); ?> <span><?php echo esc_html($settings['member_title']); ?></span></li>
								<?php endif; ?>

								<?php if (!empty($settings['button_label'])):?>
									<li class="title-anim"><a href="<?php echo esc_url($settings['button_link']['url']); ?>"><i class="fa fa-angle-right"></i> <span><?php echo esc_html($settings['button_label']); ?></span></a></li>
								<?php endif; ?>

							</ul>
							<?php if ($settings['signature']['url']):?>
								<div class="signature title-anim"><img src="<?php echo esc_url($settings['signature']['url']); ?>" alt="" /></div>
							<?php endif; ?>
						</div>
						
					</div>
				</div>
			</div>
		</div>
	</section>
    <?php
    }
}

Plugin::instance()->widgets_manager->register( new Constim_About_Info() );