<?php

/**
 * Elementor Single Widget
 * @package constim Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Constim_About_2 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-abt2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About 2', 'constim-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'constim_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'constim_sec_h_option',
			[
				'label' => esc_html__( 'Content', 'constim-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
            'aimg1',
            [
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'label' => esc_html__('About image 1', 'thepack'),
            ]
        );

		$this->add_control(
            'aimg2',
            [
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'label' => esc_html__('About image 2', 'thepack'),
            ]
        );

		$this->add_control(
            'pre',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Pre title', 'thepack'),
            ]
        );

		$this->add_control(
            'ttl',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Title', 'thepack'),
            ]
        );

		$this->add_control(
            'desc',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'label' => esc_html__('Description', 'thepack'),
            ]
        );

		$this->add_control(
            'list',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'label' => esc_html__('List', 'thepack'),
            ]
        );

		$this->add_control(
            'awrdicn',
            [
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'label' => esc_html__('Award icon', 'thepack'),
            ]
        );

		$this->add_control(
            'awrdlbl',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Award label', 'thepack'),
            ]
        );

		$this->add_control(
            'btn',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Button label', 'thepack'),
            ]
        );

		$this->add_control(
            'btnu',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Button link', 'thepack'),
            ]
        );

		$this->add_control(
            'authicn',
            [
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'label' => esc_html__('Author image', 'thepack'),
            ]
        );

		$this->add_control(
            'authlbl',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => esc_html__('Author label', 'thepack'),
            ]
        );

		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_1',
			[
				'label' => __( 'Section Style', 'thepack' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'--Subtitle-Style--',
			[
				'label' => esc_html__( 'Subtitle Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Subtitle-Color',
			[
				'label' => esc_html__( 'Subtitle Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_title.sec-title-two_heading' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Subtitle-Typography',
				'label' => esc_html__( 'Subtitle Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_title.sec-title-two_heading',
			]
		);

		$this->add_control(
			'--Title-Style--',
			[
				'label' => esc_html__( 'Title Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Title-Color',
			[
				'label' => esc_html__( 'Title Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_heading' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Title-Typography',
				'label' => esc_html__( 'Title Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_heading',
			]
		);

		$this->add_control(
			'--Description-Style--',
			[
				'label' => esc_html__( 'Description Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Description-Color',
			[
				'label' => esc_html__( 'Description Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two_text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Description-Typography',
				'label' => esc_html__( 'Description Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .sec-title-two_text',
			]
		);

		$this->add_control(
			'--Feature-Style--',
			[
				'label' => esc_html__( 'Feature Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Feature-Color',
			[
				'label' => esc_html__( 'Feature Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-two_list li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Feature-Typography',
				'label' => esc_html__( 'Feature Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .about-two_list li',
			]
		);

		$this->add_control(
			'--Award-Style--',
			[
				'label' => esc_html__( 'Award Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Award-Color',
			[
				'label' => esc_html__( 'Award Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-two_award-title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Award-Typography',
				'label' => esc_html__( 'Award Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .about-two_award-title',
			]
		);

		$this->add_control(
			'--Happy-Client-Style--',
			[
				'label' => esc_html__( 'Happy Client Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Happy-Client-Color',
			[
				'label' => esc_html__( 'Happy Client Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-two_total-client' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Happy-Client-Typography',
				'label' => esc_html__( 'Happy Client Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .about-two_total-client',
			]
		);

		$this->add_control(
			'--Button-Style--',
			[
				'label' => esc_html__( 'Button Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->start_controls_tabs('tpcnt');
		$this->start_controls_tab(
			'tab_controls_normal',
			[
				'label' => esc_html__( 'Normal', 'appilo' ),
			]
		);
		$this->add_control(
			'Button-Color',
			[
				'label' => esc_html__( 'Button Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five .btn-wrap .text-one' => 'color: {{VALUE}}',
					'{{WRAPPER}} .btn-style-five' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Button-Typography',
				'label' => esc_html__( 'Button Typography', 'textdomain' ),
				'selector' => '{{WRAPPER}} .btn-style-five',
			]
		);
		$this->add_control(
			'Button-Background-Color',
			[
				'label' => esc_html__( 'Button Background Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_controls_hover',
			[
				'label' => esc_html__( 'Hover', 'appilo' ),
			]
		);
		$this->add_control(
			'Button-Hover-Color',
			[
				'label' => esc_html__( 'Button Hover Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five:hover .btn-wrap .text-two' => 'color: {{VALUE}}',
					'{{WRAPPER}} .btn-style-five:hover .arrow' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Button-Hover-Background-Color',
			[
				'label' => esc_html__( 'Button Hover Background Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-style-five:hover:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
		
    ?>
	<section class="about-two">
		<div class="auto-container">
			<div class="row clearfix">
				<!-- Image Column -->
				<div class="about-two_image-column col-lg-6 col-md-12 col-sm-12">
					<div class="about-two_image-inner">
						<div class="about-two_image">
							<?php echo wp_get_attachment_image( $settings['aimg1']['id'],'full'); ?>
						</div>
						<div class="about-two_image-two">
							<?php echo wp_get_attachment_image( $settings['aimg2']['id'],'full'); ?>
						</div>
					</div>
				</div>
				<!-- Content Column -->
				<div class="about-two_content col-lg-6 col-md-12 col-sm-12">
					<div class="about-two_content-inner">
						<div class="sec-title-two">
							<div class="sec-title-two_title"><?php echo $settings['pre'];?></div>
							<h2 class="sec-title-two_heading"><?php echo $settings['ttl'];?></h2>
							<div class="sec-title-two_text"><?php echo $settings['desc'];?></div>
						</div>
						<div class="row clearfix">
							<div class="col-lg-7 col-md-6 col-sm-12">
								<ul class="about-two_list">
									<?php echo $settings['list'];?>
								</ul>
							</div>
							<div class="col-lg-5 col-md-6 col-sm-12">
								<div class="about-two_award-box">
									<span class="about-two_award-icon">
										<?php echo wp_get_attachment_image( $settings['awrdicn']['id'],'full'); ?>
									</span>
									<h5 class="about-two_award-title"><?php echo $settings['awrdlbl'];?></h5>
								</div>
							</div>
						</div>
						<div class="about-two_lower-box">
							<div class="d-flex align-items-center flex-wrap">
								<!-- Button Box -->
                                <?php if (!empty($settings['btn'])): ?>
                                    <div class="about-two_button">
                                        <a class="btn-style-five theme-btn btn-item" href="<?php echo $settings['btnu'];?>">
                                            <div class="btn-wrap">
                                                <span class="text-one"><?php echo $settings['btn'];?></span>
                                                <span class="text-two"><?php echo $settings['btn'];?></span>
                                            </div>
                                            <i class="arrow fa-solid fa-arrow-right fa-fw"></i>
                                        </a>
                                    </div>
                                <?php endif; ?>
								<!-- About Two Client Box -->
								<div class="about-two_client-box d-flex flex-wrap">
									<div class="about-two_client-list"><?php echo wp_get_attachment_image( $settings['authicn']['id'],'full'); ?></div>
									<div class="about-two_total-client"><?php echo $settings['authlbl'];?></div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Constim_About_2() );