<?php
/**
 * All Elementor widget init
 * @package constim
 * @since 1.0.0
 */

if ( !defined('ABSPATH') ){
	exit(); // exit if access directly
}

if ( !class_exists('Constim_Elementor_Widget_Init') ){

	class Constim_Elementor_Widget_Init{
		/*
		* $instance
		* @since 1.0.0
		* */
		private static $instance;
		/*
		* construct()
		* @since 1.0.0
		* */
		public function __construct() {
			add_action( 'elementor/elements/categories_registered', array($this,'_widget_categories') );
			//elementor widget registered
			add_action('elementor/widgets/register',array($this,'_widget_registered'));
			add_action('elementor/editor/after_enqueue_styles',array($this,'editor_style'));
		}
		/*
	   * getInstance()
	   * @since 1.0.0
	   * */
		public static function getInstance(){
			if ( null == self::$instance ){
				self::$instance = new self();
			}
			return self::$instance;
		}
		/**
		 * _widget_categories()
		 * @since 1.0.0
		 * */
		public function _widget_categories($elements_manager){
			$elements_manager->add_category(
				'constim_widgets',
				[
					'title' => __( 'constim Addons', 'magezix-core' ),
					'icon' => 'fa fa-plug'
				]
			);
		}
		

		/**
		 * _widget_registered()
		 * @since 1.0.0
		 * */
		public function _widget_registered(){
			if( !class_exists('Elementor\Widget_Base') ){
				return;
			}
			$elementor_widgets = array(	
				
				// Constim Theme Widgets
				'about_info',
				'blog-grid',
				'services',
				'section-title',
				'sponsors-widget',
				'marque-text',
				'solutions-section',
				'testimonial',
				'app-section',
				'service-2',
				'fanfact-item',
				'project-tabs',
				'hero_slide',
				'fanfact-two',
				'service-info',
				'about-box',
				'project_section',
				'accordion',
				'testimonial-quote',
				'team',
				'service-3',
				'blog-grid-v2',
				'fanfact-three',
				'contact-info',
				'testimonial-v2',
				'about_tabs',
				'works-tabs',
				'hero_video_bg',
				'fanfact-info',
				'fanfact-info',
				'marque-text-2',
				'marque-text-3',
				'team-carousel',
				'sponsors-two',
				'contact-form',
				'accordion-two',
				'social-icon',
				'team-details',
				'timeline-item',
				'video-popup',
				'service-nav',
				'download-btn',
				'sidebar-quote',
				'pricing-table',
				'project-grid',
				'project-details',
				'project-grid-overlay',
				'gallery-masonary',
				'hero_slider_2',
				'blog-grid-3',
				'testimonial-3',
				'team-carousel-two',
				'project_carousel',
				'fanfact-four',
				'faq',
				'cta',
				'service-4',
				'progress-bar',
				'icon-box',
				'cta-call',
				'service-list',
				'slider-contact',
				'section-title-two',
				'fanfact-single-item',
				'member-block',
				'contact-info-list',
				'main-slider-four',
				'about-two',
				'service-five',
				'hire-us',
				'service-seven',
				'why-choose-us',
				'testimonial-v5',
				'blog-v5',
			);
			
			$elementor_widgets = apply_filters('constim_elementor_widget',$elementor_widgets);

			if ( is_array($elementor_widgets) && !empty($elementor_widgets) ) {
				foreach ( $elementor_widgets as $widget ){
					$widget_file = 'plugins/elementor/widget/'.$widget.'.php';
					$template_file = locate_template($widget_file);
					if ( !$template_file || !is_readable( $template_file ) ) {
						$template_file = CONSTIM_DIR_PATH.'/elementor/widgets/'.$widget.'.php';
					}
					if ( $template_file && is_readable( $template_file ) ) {
						include_once $template_file;
					}
				}
			}

		}

		public function editor_style(){
			$cs_icon = plugins_url( 'icons.png', __FILE__ );
			wp_add_inline_style( 'elementor-editor', '.elementor-element .icon .appi-custom-icon{content: url( '.$cs_icon.');width: 28px;}' );
		}


	}

	if ( class_exists('Constim_Elementor_Widget_Init') ){
		Constim_Elementor_Widget_Init::getInstance();
	}

}//end if