<?php
/*
Plugin Name: constim Tools
Plugin URI: https://themeforest.net/user/themexriver
Description: After install the constim WordPress Theme, you must need to install this "constim Tools" first to get all functions of constim WP Theme.
Author: Raziul Islam
Author URI: http://themexriver.com/
Version: 1.0.1
Text Domain: constim-tools
*/
if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Define Core Path
 */
define( 'CONSTIM_VERSION', '1.0.3' );
define( 'CONSTIM_DIR_PATH',plugin_dir_path(__FILE__) );
define( 'CONSTIM_DIR_URL',plugin_dir_url(__FILE__) );
define( 'CONSTIM_INC_PATH', CONSTIM_DIR_PATH . '/inc' );
define( 'CONSTIM_PLUGIN_IMG_PATH', CONSTIM_DIR_URL . '/assets/img' );

/**
 * Css Framework Load
 */
if ( file_exists(CONSTIM_DIR_PATH.'/lib/codestar-framework/codestar-framework.php') ) {
    require_once  CONSTIM_DIR_PATH.'/lib/codestar-framework/codestar-framework.php';
}


/**
 * Register Custom Widget
 *
 * @return void
 */
function constim_cw_wisget(){
    register_widget( 'Constim_Recent_Posts' );
}
add_action('widgets_init', 'constim_cw_wisget');


/**
 * Deregister Elementor Animation
 *
 * @return void
 */
function constim_de_reg() {
    wp_deregister_style( 'e-animations' );
}
add_action( 'wp_enqueue_scripts', 'constim_de_reg' );

/**
 * Enqueue Admin Style
 *
 * @return void
 */
function wpdocs_enqueue_custom_admin_style() {
    wp_enqueue_style( 'custom_wp_admin_flaticon', get_template_directory_uri() . '/assets/css/flaticon.css', false, '1.0.0' );
    wp_enqueue_style( 'constim-admin-style', CONSTIM_DIR_URL . "assets/css/admin-style.css");
}
add_action( 'admin_enqueue_scripts', 'wpdocs_enqueue_custom_admin_style' );

/**
 * Recent Post Widget
 */
include_once CONSTIM_INC_PATH . "/custom-widget/recent-post.php";


/**
 * Custom Metabox
 */
include_once CONSTIM_INC_PATH . "/options/theme-metabox.php";

/**
 * Themeoption
 */
include_once CONSTIM_INC_PATH . "/options/theme-option.php";

/**
 * Helper Function
 */
include_once CONSTIM_INC_PATH . "/helper.php";

/**
 * Elementor Custom Icon Liberary
 */
include_once CONSTIM_INC_PATH . "/constim-icon.php";

/**
 * Custom Post
 */
include_once CONSTIM_INC_PATH . "/cpt/constim-cpt.php";


/**
 * Codestar Custom Icon Liberary
 */
include_once CONSTIM_INC_PATH . "/csf-custom-icon.php";

/**
 * Elementor Configuration
 */
include_once CONSTIM_DIR_PATH . "/elementor/elementor-init.php";

/**
 * Helper Function
 */
include_once CONSTIM_INC_PATH . "/domain-functions.php";
